<?php

/* ADD BLOG SECTION
***************************************************/
Goto_Kirki::add_section( 'blog', array(
    'title'      => esc_attr__( 'Blog', 'goto' ),
    'priority'   => 1,
));




Goto_Kirki::add_field( 'goto', array(
    'type'        => 'radio-buttonset',
    'settings'    => 'blog_header_layout_cfg',
    'label'       => esc_attr__( 'Menu Layout', 'goto' ),
    'section'     => 'blog',
    'default'     => 'layout-1',
    'description' => esc_attr__( 'Choose Menu Preset Select your main header preset here to apply for Blog pages', 'goto' ),
    'choices'     => array(
        'layout-1' => esc_attr__( 'Layout 1', 'goto' ),
        'layout-2' => esc_attr__( 'Layout 2', 'goto' ),
        'layout-3' => esc_attr__( 'Layout 3', 'goto' ),
    ),
    'partial_refresh' => array(
        'blog_menu_layout' => array(
            'selector'        => '.group-blog #theme-menu-layout',
            'render_callback' => 'goto_menu_layout',
        ),
    ),
));

/*blog title*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'text',
    'label'     => esc_html__( 'Blog title', 'goto' ),
    'settings'  => 'blog_title',
    'section'   => 'blog',
    'default'   => 'Blog',
    'transport' => 'postMessage',
    'js_vars'   => array(
        array(
            'element'  => '.group-blog .page-title',
            'function' => 'html',
        ),
    ),
));


/*sidebar position*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'radio-image',
    'label'    => esc_html__( 'Sidebar position', 'goto' ),
    'settings' => 'blog_sidebar',
    'section'  => 'blog',
    'default'  => 'right',
    'choices'  => array(
        'left'  => get_template_directory_uri() . '/images/sidebar/left.png',
        'full'  => get_template_directory_uri() . '/images/sidebar/full.png',
        'right' => get_template_directory_uri() . '/images/sidebar/right.png',
    )
));